<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequirementAnswer extends Model 
{

    protected $table = 'requirement_answers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'type_requirement_id', 'answer');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function type_requirement()
    {
        return $this->belongsTo('App\Models\TypeRequirement');
    }

}